/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#ifndef _COMMANDPACKAGER_H_
#define _COMMANDPACKAGER_H_

#include "U4ADefines.h"

typedef struct commPackage {
    command tc;
    union {
        struct { // OPEN ==>
            int usbin;
            int usbout;
            char name[MAX_LEN_NAME];
        };
        struct { // OPEN <==
            int newhnd;
        };
        struct { // CLOSE ==>
            int hnd;
        };
        struct { // CLOSE <==
            int ack;
        };
        // MESSAGE ==>
        // MESSAGE <==
        // LOAD ==>
        // LOAD <==
        // UNLOAD ==>
        // UNLOAD <==
        // MODULE_QTY ==>
        struct { // MODULE_QTY <==
            int cant;
        };
        struct { // MODULE_NAME ==>
            int index;
        };
        struct { // MODULE_NAME <==
            char mod[MAX_LEN_NAME];
        };
        // INIT ==>
        // INIT <==
        // CONFIGURE ==>
        // CONFIGURE <==
    };
};

typedef struct commPackageResponse {
    unsigned char tc;
    union {
        struct { // OPEN
            unsigned char hnd;
        };
        struct { // CLOSE
            unsigned char ack;
        };
        // MESSAGE
        // LOAD
        // UNLOAD
        struct { // MODULE_QTY
            unsigned char cant;
        };
        struct { //MODULE_NAME
            char mod[MAX_LEN_NAME];
        };
        // INIT
        // CONFIGURE
    };
};

class CommandPackager {
    public:
        CommandPackager();
        ~CommandPackager();
        char * buildPackage(commPackage*, int&);
        commPackage* unbuildPackage(char*, int);
};

#endif
